<!DOCTYPE html>
<html lang="zxx">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
<!--<meta name="keywords" content="<?php echo $seo->meta_keywords; ?>" /> -->

<!--<meta name="description" content="<?php echo $seo->meta_content; ?>" />   -->

<!-- Primary Meta Tags -->
<title>Crash Rated Bollards | Eleazar International UAE</title>
<meta name="description" content="Explore Eleazar International's range of crash-rated bollards, including PAS 68, K4, K8, and K12 models. Designed for high-impact protection in public spaces, our bollards are available in fixed, removable, and shallow mount options.">
<meta name="keywords" content="crash rated bollards, PAS 68 bollards, K4 bollards, K8 bollards, K12 bollards, fixed bollards, removable bollards, shallow mount bollards, vehicle impact protection, security bollards, Eleazar International, UAE bollard suppliers">
<meta name="author" content="Eleazar International">

<link rel="canonical" href="https://eleazarintl.com/crashrated-bollard-products">

<!-- Open Graph / Facebook -->
<meta property="og:title" content="Crash Rated Bollards | Eleazar International UAE">
<meta property="og:description" content="Discover our high-impact crash-rated bollards, including PAS 68, K4, K8, and K12 models. Ideal for securing public spaces and infrastructure.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://eleazarintl.com/crashrated-bollard-products">
<meta property="og:image" content="https://eleazarintl.com/images/crash-rated-bollards.jpg">
<meta name="robots" content="index, follow">
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Crash Rated Bollards | Eleazar International">
<meta name="twitter:description" content="Certified crash-rated bollards for enhanced security. Explore our range suitable for various applications across the UAE.">
<meta name="twitter:image" content="https://eleazarintl.com/images/crash-rated-bollards.jpg">
<meta name="twitter:site" content="@eleazarinrntl">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />


<?php 
//$ga=$seo->google_analytics;
//echo htmlspecialchars_decode($ga, ENT_QUOTES);
?>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-7MKCHHQ082"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-7MKCHHQ082');
</script>


<?php echo html_entity_decode($seo->schema_script); ?>


<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-PKVC4ND');</script>
<!-- End Google Tag Manager -->

      <!--<title><?php echo $seo->title_tag; ?></title>-->
      <link rel="icon" href="<?php echo base_url();?>images/elogo.png" type="image/x-icon">
      <!-- Bootstrap -->
      <link href="<?php echo base_url();?>css/bootstrap.min.css" rel="stylesheet">
      <link href="<?php echo base_url();?>css/style.css" rel="stylesheet">
      <link href="<?php echo base_url();?>css/responsive-style.css" rel="stylesheet">
      <link href="<?php echo base_url();?>css/effect_style.css" rel="stylesheet">
      <link rel="stylesheet" href="<?php echo base_url();?><?php echo base_url();?>css/animate.min.css">
      <link rel="stylesheet" href="<?php echo base_url();?>css/animate.css">
      <link href="<?php echo base_url();?>css/responsive_bootstrap_carousel.css" rel="stylesheet" media="all">
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>css/demo.css" />
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>css/set1.css" />

  <style>
@media(max-width:700px)
  {
 .var2-nav
 {
 background: none!important;
 height: 53px!important;    
     
 }
 }    
</style> 

   </head>
   <body>
      <!--=========header start============-->
      <header class="header2">
         <div class="container">
            <div class="row">
               <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 display-block ">
                  <a href="<?php echo base_url();?>" class="logo"><img src="<?php echo base_url();?>images/eleazarinternational.png" class="img-responsive" alt="eleazarinternational" style=""></a>
               </div>
               <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12 pull-right">
                  <ul class="header-info">
                      <li class="phn"><a href="tel:+971 6 579 79 79">+971 6 579 79 79<br/></a></li>
                     
                     <li class="email"><a href="mailto:info@eleazarintl.com"style="color: #575757;">info@eleazarintl.com</a></li>
                     
                    <li class="" style="padding: 0px 5px;display:flex"><i class="fa fa-whatsapp" aria-hidden="true"
                     style="font-size: 26px;color: #42db87;"></i><a target="_blank" href="https://wa.me/+971543605892" style="color: #575757;margin-top: 3px;
                      padding-left: 10px;"> +971 54 360 5892</a></li>
                     
                     
                  </ul>
                  
               </div>
            </div>
         </div>
         <nav id="main-navigation-wrapper" class="navbar navbar-default navbar2-wrap ">
            <div class="container">
               <div class="navbar-header">
                  <div class="logo-menu"><img src="<?php echo base_url();?>images/eleazarinternational.png" alt="eleazarinternational"></div>
                  <button type="button" data-toggle="collapse" data-target="#main-navigation" aria-expanded="false" class="navbar-toggle collapsed"><span class="sr-only">Toggle navigation</span><span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span></button>
               </div>
               <div class="var2-nav">
                  <div id="main-navigation" class="collapse navbar-collapse ">
                     <ul class="nav navbar-nav">
                        <li class="">
                           <a href="<?php echo base_url();?>" >Home</a><i class="fa fa-chevron-down"></i>
                           
                        </li>
                        <li class="">
                           <a href="<?php echo base_url();?>about-flexible-bollard-products" >About Us</a><i class="fa fa-chevron-down"></i>
                          
                        </li>
                        <li class="dropdown">
                           <a href="" class="active">Products</a><i class="fa fa-chevron-down"></i>
                           <ul class="dropdown-submenu">
                           
                              <li><a href="<?php echo base_url();?>crashrated-bollard-products">Bollards</a></li>
                              <li><a href="<?php echo base_url();?>tactile-indicators-products">Tactile Indicator</a></li>
                              <li><a href="<?php echo base_url();?>stair-noses-products">Stair Noses</a></li>
                              
                              <li><a href="<?php echo base_url();?>pvc-vinyl-suppliers">PVC & Vinyl Products</a></li>
                              <li><a href="<?php echo base_url();?>road-traffic-safety-products">Traffic Safety Products</a></li>
                      
                           </ul>
                           
                        </li>
                        <li class="dropdown">
                           <a href="<?php echo base_url();?>gallery-fixed-bollard-products">Gallery</a><i class="fa fa-chevron-down"></i>
                           
                        </li>
                         
                        
                        <li><a href="<?php echo base_url();?>contact-removable-bollard-products">contact us</a></li>
                     </ul>
                   
                     <a class="header-requestbtn header2-requestbtn hvr-bounce-to-right" href="<?php echo base_url();?>request-quote">Request A Quote</a>
                  </div>
               </div>
            </div>
         </nav>
      </header>
      <!--=========header end============-->
      <!--=========Banner Start
      
      
      <div class="inner-pages-bnr" style="margin-top: -1.7%;">
         <img src="<?php echo base_url();?>images/bol.jpg" class="img-responsive" alt="chemical-banner-image">
         <div class="banner-caption">
            <h1>Bollards</h1>
            
         </div>
      </div>
   Banner end============-->
      
      
      <section class="pad100-top-bottom">
         <div class="container">
            <div class="row">
               <!--=========Servie Left Start============-->
               <div class="col-lg-4 col-md-5 col-sm-5 col-xs-12 left-column">
                  <ul class="category-list">
                     <li><a href="<?php echo base_url();?>crashrated-bollard-products" class="active-category">Bollards</a></li>
                     <li><a href="<?php echo base_url();?>tactile-indicators-products">Tactile Indicator</a></li>
                     <li><a href="<?php echo base_url();?>stair-noses-products" >Stair Noses</a></li>
                     <li><a href="<?php echo base_url();?>pvc-vinyl-suppliers">PVC & Vinyl Products</a></li>
                     <li><a href="<?php echo base_url();?>road-traffic-safety-products">Traffic Safety Products</a></li>
                    
                  </ul>
                  <div class="contact-help" style="margin-top: 25%;">
                     <div class="office-info-col wdt-100">
                        <h4>CONTACT US </h4>
                        <ul class="office-information">
                           <li class="office-loc">
                              <span class="info-txt">P.O. Box: 73500, Sharjah, <br>United Arab Emirates</span>
                           </li>
                          <li class="office-phn">
                              <span class="info-txt fnt_17"> <a href="tel:+971 6  598 52 60" style="color: #bcbcbc;">
                              +971 6 579 79 79</a></span>
                           </li>
                           <li class="office-msg">
                          <span class="info-txt fnt_17">
                        <a href="mailto:info@eleazarintl.com" 
                        style="color: #bcbcbc;">info@eleazarintl.com</a></span>
                           </li>
                        </ul>
                     </div>
                  </div>
                 
               </div>
               <!--=========Servie Left end============-->
               <!--=========Servie Right Start============-->
               <div class="col-md-8 right-column pull-right">
                  <div class="service-right-desc">
                     
                     <span class="image_hover ">
                     <img src="<?php echo base_url();?>images/products/home/eleazarbollards.JPG" class="img-responsive zoom_img_effect" alt="eleazar bollards">
                     </span>
                     <?php /*<h5><?php echo $bollards->description; ?></h5> */ ?>
                     <br>
                     <p>Eleazar International offers bollards in Stainless steel, Mild Steel, Galvanized steel, Wood, PVC…. etc.. Our bollards are offered in various finishes like mirror, satin finish etc. Our product offering also includes PAS 68, K4, K8, K12  crash rated fixed bollards that are available in standard & shallow foundations.</p>
                     
                     <p>Traffic bollards are used to guide traffic toward appropriate areas while ensuring clear sight lines and allowing pedestrian access. They guide cars by creating roadway demarcation, or prevent access to restricted areas like bike lanes, public squares, and traffic islands. On roadways without curbs, they can be used to prevent vehicles straying from the street. Sometimes they are used in association with other traffic calming methods, like speed humps or one-way streets, to prevent vehicles from attempting to avoid other traffic management elements</p>
                    
                  </div>
                  
                  
               </div>
               <!--=========Servie Right end============-->
            </div>
         </div>
      </section>
      
      
      

 <!--=========Portfolio Start============-->
      <div class="filter-section" style="margin-top: -8%;">
          
         <div class="col-sm-12 col-xs-12">
            <div class="filter-container isotopeFilters">
               <ul class="list-inline filter">
                   
                 <!-- <li class="cat-item cat-item-1 "><a href="#" data-filter="*">All Bollards </a></li> -->
                  
                  <li class="active"> <a href="#" data-filter=".fixed">
                      Fixed</a> </li>
                  <li class="cat-item cat-item-2"> <a href="#" data-filter=".removed">Removable</a> </li>
                  <li class="cat-item cat-item-3"> <a href="#" data-filter=".fold">Fold down</a> </li>
                  <li class="cat-item cat-item-4"> <a href="#" data-filter=".semi">Semi Automatic</a> </li>
                  <li class="cat-item cat-item-5"> <a href="#" data-filter=".crash">Crash Rated</a> </li>
                  <li class="cat-item cat-item-6"> <a href="#" data-filter=".retra">Retractable</a> </li>
                  <li class="cat-item cat-item-7"> <a href="#" data-filter=".flex">Flexible </a> </li>
               </ul>
            </div>
         </div>
      </div>
      
      
      <section class="portfoio-section3">
         <!-- /nimble-portfolio-filter -->
         <div class="container">
            <div class="portfolio-section port-col project_classic portfolio-3">
               <div class="isotopeContainer">
                   
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel2.jpg" alt="fixed bollards model2">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                   
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel3.jpg" alt="fixed bollards model2">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                   
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
               <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel4.jpg" alt="fixed bollards model4">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel5.jpg" alt="fixed bollards model5">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel6.jpg" alt="fixed bollards model6">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                    
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel7.jpg" alt="fixed bollards model7">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel8.jpg" alt="fixed bollards model8">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel9.jpg" alt="fixed bollards model9">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel10.jpg" alt="fixed bollards model10">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodel11.jpg" alt="fixed bollards model11">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/FbLed10.jpg" alt="Stainless Bollards with customized logo">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/ADM-219-Led.jpg" alt="Stainless Bollards with customized logo">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodelcs11.jpg" alt="fixed bollards modecs11">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fixed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/fixed/fixedbollardsmodelcs12.jpg" alt="fixed bollards modelcs12">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                
                  
   
                  <!-- removed -->
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodelcs7.jpg" alt="removable bollards modelcs7">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodelcs8.jpg" alt="removable bollards modelcs8">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                       
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
               <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodelr1.jpg" alt="removable bollards modelr1">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel1.jpg" alt="removable bollards model1">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel2.jpg" alt="removable bollards model2">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel3.jpg" alt="removable bollards model3">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel5.jpg" alt="removablebollardsmodel5">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel4.jpg" alt="removable bollards model4">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector removed">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/removed/removablebollardsmodel12.jpg" alt="removable bollards model12">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                   
                  
                  <!-- falldown -->
                   <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fold">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/falldown/falldownbollardsmodel1.jpg" alt="falldown bollards model1">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fold">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/falldown/falldownbollardsmodel2.jpg" alt="falldown bollards model2">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector fold">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/falldown/falldownbollardsmodel3.jpg" alt="falldown bollards model3">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <!-- semi -->
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector semi">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/semi/semiautomaticbollard.jpg" alt="semi automatic bollard">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector semi">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/semi/semiautomaticbollards.jpg" alt="semi automatic bollards">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <!-- crash -->
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector crash">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/crash/crashratedbollard.jpg" alt="crashrated bollard">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector crash">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/crash/crashratedbollards.jpg" alt="crashrated bollards">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <!-- retra -->
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector retra">
              <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/retra/rectanglebollards.jpg" alt="rectangle bollards">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <!-- flexible -->
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector flex">
                     <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/flex/flexiblebollards1.jpg" alt="flexible bollards1">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector flex">
                 <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/flex/flexiblebollards2.jpg" alt="flexible bollards2">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector flex">
                 <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/flex/flexiblebollards3.jpg" alt="flexible bollards3">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
                  
                  <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector flex">
                 <div class="grid">
                     <div class="">
                              <div class="gal-item">
                                 <a class="" href="">
                                    <img class="img-full img-responsive" src="<?php echo base_url();?>images/bollards/flex/flexiblebollards4.jpg" alt="flexible bollards4">
                                    <div class="tour-layer delay-1"></div>
                                    <div class="vertical-align">
                                        <div class="border">
                                          <h5></h5>
                                        </div>
                                        
                                   </div>
                              </a>
                           </div>
                        </div>
                           </div>
                  </div>
                  
               
                 <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 img mbot30 isotopeSelector flex">
                     
                     <video  width="420" height="240" controls>
                    <source src="<?php echo base_url();?>images/bollards/flex/fvideo.mp4" type="video/mp4">
                    <source src="<?php echo base_url();?>images/bollards/flex/fvideo.ogg" type="video/ogg">
                </div>    
                    
                  
               </div>
            </div>
            <!-- /nimble-portfolio --> 
         </div>
      </section>
      <!--=========Portfolio end============-->
      
      
      <section >
   <div class="container">
       <br>
       <h3 style="font-size: 21px;margin-bottom: 22px;">Fixed Bollards</h3>
       
       <p>The surface mounted fixed bollards can be used for areas like traffic control, Landscapes, car park, escalator …etc. Fixed bollards protect buildings and equipment while adding to the overall aesthetic of the facility</p>
       
       <p>Cast in types fixed bollards used to protect fire hydrant and electrical panel, also where the traffic to be controlled near shopping mall , bus and train stations or government buildings. </p>
       
       <p>Crash rated fixed bollards protect people, public spaces and property from undesired contact with vehicles , whether accidental or deliberate. The crash rated bollards are designed for the safety of pedestrian on accident prone areas and public places. These bollards are with the deep foundation minimum of 400 mm </p>
       
       <p>There are Shallow mounted crash rated bollards also available with less foundation depth minimum of 300 mm . </p>
       
       <p>The client required the bollard, to be surface mounted, and with no complicated installation, Just a simple install solution :- This new design is light weight single bollard that can be fitted straight onto an existing concrete surface without having to dig up the existing surface and will still give you the full protection of 7.2 ton vehicle travelling at 30 mph or 48 kph at 90 degrees without the cost and inconvenience of digging up the roadway or footpath.  It can be a stand-alone single unit or a row of bollards. ‘No heavy plant is needed’ to install. The bollards are delivered on break down kits and can be built up on site and fitted with a two-man team.</p>
       
       <br>
       <h3 style="font-size: 21px;margin-bottom: 22px;">Removable Bollards </h3>
       
       <p>Removable bollards allow occasional vehicle traffic without sacrificing security.</p>
       
       <p>Surface mounted removable bollards do not require excavation as it bolted on the surface. Available with or without locking system. These bollards are easy handling and available in various designs. </p>
       
       <p>Removable bollards are also available with base sleeve with safety flap. Where there’s provision of excavations. These bollards available in various types of locking system including pad locks.</p>
      
       
       
       <br>
       <h3 style="font-size: 21px;margin-bottom: 22px;">Fold down bollards </h3>
       
       <p>The surface mounted fold down bollards generally using in car parks to reserve. The excavation not required for these type of bollards.  Available in mild steel and stainless steel with locking system.</p>
     
    <br>   
    
    
     <h3 style="font-size: 21px;margin-bottom: 22px;">Semi automatic and Retractable</h3>
       
       <p>type bollards also available in various models and designs. </p>
       
       <br>   
    
    
     <h3 style="font-size: 21px;margin-bottom: 22px;">Flexible Bollards </h3>
       
       <p>Flexible bollards are designed to do no damage to vehicles that hit them.</p>
       
       <p>Polyurethane bends on impact with little injury to either car or bollard, popping back up after the vehicle moves away. These flexible posts are often found in parking lots, used as parking stall poles or guiding traffic. Clipping one will tell a driver to get back into position, but will otherwise not slow or stop the car. They are occasionally used on medians or as lane delimiters.</p>
       
       <p>Knock-down or rebounding versions are not flexible in the bollard body but rather sit on flexible bases. The post is often made of hard high-visibility plastic and is designed to be easily replaced if damaged by vehicle strike. They’re often used as lane delineators on highways or other heavy traffic areas.</p>
       
       <p>The flexible bollards / delineators are available with High performance plastic , TPU and specially formulated materials. in the event of a collision, if its maximum flexibility point is not exceeded, the bollard will go back to its original position, without losing its shape or form. If the point of maximum flexibility is exceeded, this bollard won’t break as if it was made from conventional plastic, iron or cast iron. This peculiar quality makes it an economic and durable option. </p>
       
       <p>In many landscapes and properties, decorative bollards are used to define distinct pedestrian areas. A line of them around a building may define its perimeter and add architectural flair. Perimeters can also be made around a playground or park, allowing easy access but discouraging its use as a throughway. When linked with chain, bollards can encourage pedestrians to stay on marked paths, without forming a closed barrier that prevents all crossing. Lighted versions illuminate pedestrian pathways at night. Solar powered lighting is becoming the most frequently used form of lighting bollard, since each unit functions on its own with very little maintenance</p>
       
       <p>On roadway construction zones, temporary posts are often placed to define and protect the work area from traffic. These delimiters are usually made of flexible brightly colored plastic ringed in reflective tape, and sit on removable rubber bases. They are usually spaced closely, to provide a continual visual edge to the oncoming traffic.</p>
       
       <p>Security bollards are also visual guides to pedestrians and traffic, but are additionally built to resist vehicle impact. These are often made of steel and filled with concrete, but can be decorated with a fine finish or a cover. In general, the local substrate and installation are essential parts of impact resistance: a strong bollard set poorly will offer little resistance. Engineering oversight is therefore essential. Different applications will also have different impact resistance needs</p>
       
       <p>Playgrounds near parking lots, parks beside sharp bends in the road, outdoor patios by busy roadways: these are just some of the places that security bollards might help prevent an accident from becoming a tragedy. Steel-and-concrete is available in a variety of widths that should be matched to the vehicle speeds and distance of pedestrian zone to roadway. They are usually covered with sleeves or covers for corrosion protection and attractiveness.</p>
       
       <p>Safety bollards are often installed in front of vulnerable building components to minimize damage in the event of an accident. They are not usually designed with the idea there will be purposeful attack against them, so are often specified with suggested diameters of steel pipe to be filled with concrete. In some jurisdictions, vulnerable gas or water meters are required to have security bollards in bright colors installed as barrier posts around them. They are also often placed in front of vulnerable or historical architectural features close to traffic to protect against accident. They are not used for places likely to attract attack</p>
       
       <p>Bollards powered by solar panel or set onto an electrical grid can be installed to provide light along pedestrian pathways. Vehicle traffic posts are not generally illuminated, since bollard height is too short to light a large enough area, but reflective surfaces are common in traffic specific applications.</p>
    
    
       
       </section>


            <!--=========Footer Start============-->
      <footer>
         <div class="yellow-background solution-available text-center">
            <div class="container">
               
            </div>
         </div>
         <div class="ftr-section">
            <div class="container">
               <ul class="footer-info">
                  <li class="">Eleazar International FZE <br>P.O. Box: 73500<br/> Sharjah, UAE</li>
                  
                  <li class="ftr-phn" style="margin-left: 1%;">
                  <a href="tel:+971 6 579 79 79" style="color: #fff;">
                  +971 6 579 79 79</a></li>
                  
                  <li class="ftr-msg" style="margin-left: 1%;">
                  <a href="mailto:info@eleazarintl.com" style="color: #fff;">info@eleazarintl.com
                  </a></li>
                  <li class=""><i class="fa fa-fax" aria-hidden="true" style="position: absolute;font-family: 'FontAwesome';
                   top: 12px;
                   left: 0px;
                   font-size: 20px !important;
                   color: #fff;"></i>
                   +971 6 535 93 78</li>
               </ul>
               
               
               <div class="row">
                  <div class="col-md-4 col-sm-6 col-xs-12  ftr-about-text">
                     <h6>About Us</h6>
                     <p class="marbtm20 line-height26" style="text-align: justify;">
                     Eleazar International is one of the leading Manufacturer, importer & distributor based in UAE.
                  </p>
                     <a class="ftr-read-more" href="<?php echo base_url();?>about-flexible-bollard-products">Read More</a>
                  </div>
                  <div class="col-md-3 col-sm-6 col-xs-12 ftr-sol-column">
                     <h6>Our Products</h6>
                     <ul class="footer-link">
                        <li><a href="<?php echo base_url();?>crashrated-bollard-products">- Bollards</a></li>
                        <li><a href="<?php echo base_url();?>tactile-indicators-products">- Tactile Indicator</a></li>
                        <li><a href="<?php echo base_url();?>stair-noses-products">- Stair Noses</a></li>
                       
                        <li><a href="<?php echo base_url();?>pvc-vinyl-suppliers">- PVC & Vinyl Products</a></li>
                        <li><a href="<?php echo base_url();?>road-traffic-safety-products">- Traffic Safety Products</a></li>
                       
                     </ul>
                  </div>
                  <div class="col-md-2 col-sm-6 col-xs-12 ftr-link-column">
                     <h6>Quick Links</h6>
                     <ul class="footer-link">
                        <li><a href="<?php echo base_url();?>about-flexible-bollard-products">- About Us</a></li>
                        
                        <li><a href="<?php echo base_url();?>gallery-fixed-bollard-products">- Gallery</a></li>
                        <li><a href="<?php echo base_url();?>contact-removable-bollard-products">- Contact us</a></li>
                     </ul>
                  </div>
                  <div class="col-md-3 col-sm-6 col-xs-12 ftr-follow-column pull-right">
                     <h6 style="padding-left: 24%;">Follow Us</h6>
                     <div class="header-socials footer-socials"> 
                        <a href="https://www.facebook.com/eleazarinternational/"><i class="fa fa-facebook" aria-hidden="true"></i></a> 
                        <a href="https://twitter.com/eleazarinrntl"><i class="fa fa-twitter" aria-hidden="true"></i></a> 
                        <a href="https://www.instagram.com/eleazarinternational/"><i class="fa fa-instagram" aria-hidden="true"></i></a> 
                        <a href="https://www.linkedin.com/company/eleazarinternational"><i class="fa fa-linkedin" aria-hidden="true"></i></a> 
                     </div>
                    
                  </div>
               </div>
               
               
               <div class="footer-btm">
                  <div class="col-md-6 col-sm-6 col-xs-12 pad-left_zero pad-right_zero">
                     <p>Copyright © 2015 Eleazar International FZE. All Rights Reserved.</p>
                  </div>
                  
                <!--  <div class="col-md-4 col-sm-6 col-xs-12 pad-left_zero pad-right_zero pull-right">
                     <p class="text-right">Developed by: <a href="https://kreatz.com">
                     <img src="<?php echo base_url();?>images/kr.png" style="width: 18%;margin-top: -1%;"></a></p>
                  </div> -->
                  
               </div>
            </div>
         </div>
      </footer>
      
      <!--=========Footer end============-->
   <!-- jQuery (necessary for Bootstrap's JavaScript plugins) --> 
   <script src="<?php echo base_url();?>js/jquery.min.js"></script> 
   <!-- Include all compiled plugins (below), or include individual files as needed --> 
   <script src="<?php echo base_url();?>js/bootstrap.min.js"></script> 
   <script src="<?php echo base_url();?>js/custom.js"></script>
   <script src="<?php echo base_url();?>js/theme.js"></script>
   <script src="<?php echo base_url();?>js/imagelightbox.min.js"></script>
   <script src="<?php echo base_url();?>js/isotope.min.js"></script> 
   <script src="<?php echo base_url();?>js/main.js"></script>
      </body>
</html>